#v 0.26
#dynamic offset with mousemove is by fredo6
#most of the rest by a4chitect
class SmartPP
def initialize
		@fun = 0
		@drawtemp = 0
		@operation = 1
    @xdown = 0
    @ydown = 0
		@smarttoggle = 1
end

def activate
    @ip_origin = Sketchup::InputPoint.new
		@ip_end = Sketchup::InputPoint.new
    @drawn = false
    self.reset(nil)
end

def deactivate(view)
    view.invalidate if @drawn
end

def onMouseMove(flags, x, y, view)
	view.invalidate
	if(@drawtemp != 1) #we are looking for the face to push/pull
		@ip_origin.pick view, x, y
		@xorig = x
		@yorig = y
		@pt_origin = @ip_origin.position if @ip_origin.valid?
		view.tooltip = @ip_origin.tooltip
		
		ph = view.pick_helper
		ph.do_pick x,y
		best = ph.best_picked
		if (best)
			if(best.typename == 'Face')
				@face = best
				@target = Sketchup.active_model.active_entities
				@fun = 1
				@transformation = Geom::Transformation.new(Geom::Vector3d.new(0,0,0))
			end
			if(best.typename == 'Group')
				@face = best
				@target = best.entities
				@transformation = best.transformation
				faceip = Sketchup::InputPoint.new
				faceip.pick(view,x,y)			# Get current screen coordinates.
				@face = faceip.face			# If hovering over a face, this will return the face definition.
				if @face
					@fun = 1
				end
			end
		else
			@fun = 0
		end
	else #we are in the push/pull offset draggin phase
		@ip_end.pick view, x, y
		@xend = x
		@yend = y
		@axis = @face.normal
		view.tooltip = @ip_end.tooltip
		if @ip_end.valid? && @ip_end != @ip_origin
			@pt_end = (@axis) ? compute_lock(view, flags, @ip_end, @axis) : @ip_end.position
		end
		@offset = @pt_end - @pt_origin
	end
end

#Projection of input point for axis lock
def compute_lock(view, flags, ip, vec)
	if (vec.parallel? @pt_origin.vector_to(ip.position))
		return ip.position
	elsif (flags == 0) && (ip.degrees_of_freedom == 0)	#When Shift pressed, skip inference
		return ip.position.project_to_line([@pt_origin, vec])
	else
		pvorig = view.screen_coords @pt_origin
		pv0 = view.screen_coords @pt_origin.offset(vec, 100)
		pvip = view.screen_coords ip.position
		pv1 = pvip.project_to_line [pvorig, pv0]
		a = Geom.closest_points [@pt_origin, vec], view.pickray(pv1.x, pv1.y)
		return a[0]
	end	
end

def onLButtonDown(flags, x, y, view)
	if(@drawtemp==1)
		self.smartPP(view)
	else
		Sketchup::set_status_text "Drag to smart push or pull face or enter value.", SB_PROMPT
		@drawtemp = 1
	end
end

# The onLButtonUp method is called when the user releases the left mouse button.
def onLButtonUp(flags, x, y, view)
end

def onKeyDown(key, repeat, flags, view)
end

def onKeyUp(key, rpt, flags, view)
	key = Traductor.check_key key, flags, true

	case key
	#when 13			#Return key
		#self.smartPP(view)
	when 9		#TAB key
		if(@smarttoggle==1)
			@smarttoggle = 0
		else
			@smarttoggle = 1
		end
		view.invalidate
		#puts @smarttoggle
	end
end

def onUserText(text, view)
	if (@drawtemp)
		len = text.to_l
		if len > 0
			@offset.length = len
			@newplane = []
			vertices = @face.vertices
			0.upto(2) {|v|
				@newplane.push Geom::Point3d.new(vertices[v].position) + @offset
			}
			@newplane = Geom.fit_plane_to_points @newplane
			self.smartPP(view)
		end	
	end
end

def draw(view)
	if(@fun==1)
		#Sketchup::set_status_text @normala.to_s + " : " + @normalb.to_s, SB_PROMPT
		facebounds = []
		@face.vertices.each {|i|
			facebounds.push (i.position.transform! @transformation)
		}
		status = view.drawing_color = "blue"
		status = view.line_width = 4
		status = view.draw GL_LINE_LOOP, facebounds
		#status = view.draw GL_POLYGON, facebounds
	end
	if(@drawtemp==1)
		@newplane = []
		vertices = @face.vertices

		@smartface = []

		0.upto(2) {|v|
			@newplane.push Geom::Point3d.new(vertices[v].position) + @offset
		}

		@newplane = Geom.fit_plane_to_points @newplane
		status = view.drawing_color = "red"
		status = view.line_width = 1
		vertices.each {|v|
			# if(v.faces.length>1)
				 # boundfaces= v.faces
				 # boundfaces.delete(@face)
				 # line = Geom.intersect_plane_plane(boundfaces[0].plane, boundfaces[1].plane)
				 # pt = Geom.intersect_line_plane(line, @newplane)
			if(v.edges.length>2)
				failed = 0
				boundedges = v.edges
				#lets remove all edges planar to the selected face - as they dont define any extrusion path for us
				boundedges.delete_if {|x| x.line[1].perpendicular? @face.normal}
				#puts boundedges
				if(boundedges.length > 0 && @smarttoggle==1)
					pt = Geom.intersect_line_plane(boundedges[0].line, @newplane)
				else
					pt = v.position.project_to_plane @newplane
				end
			else
				ovector = @face.normal
				ovector.length = @offset.length
				if((@offset.angle_between @face.normal) > Math::PI/2)
					ovector.reverse!
				end
				pt = Geom::Point3d.new(v.position) + ovector
			end

			ptstart = pt.transform @transformation
			ptend = v.position.transform @transformation

			status = view.draw_line ptstart, ptend
			@smartface.push pt
		}

		@smartface.each {|pt|
			pt.transform! @transformation
		}
		
		status = view.drawing_color = "red"
		status = view.line_width = 2
		status = view.draw GL_LINE_LOOP, @smartface
		status = view.draw_points @pt_end, 2,1,"red"
		status = view.draw_points @pt_origin, 4,2,"blue"
		status = view.drawing_color = "red"
		status = view.line_width = 1
		view.line_stipple = "-"
		status = view.draw GL_LINES, @pt_origin, @pt_end
	end
	if (@pt_end)
		d = @offset.length.to_l
	else	
		d = ""
	end	
	Sketchup.set_status_text d, SB_VCB_VALUE
end

# onCancel is called when the user hits the escape key
def onCancel(flag, view)
    self.reset(view)
end

# Reset the tool back to its initial state
def reset(view)
    #@state = 0
    Sketchup::set_status_text("Smart Push/Pull", SB_PROMPT)
		@drawtemp = 0
    @dragging = false
end

# Create new geometry when the user has selected a point.
def smartPP(view)
Sketchup.active_model.start_operation "Smart Push/Pull"
#0.upto(smartface.length-2) {|i|
#@target.add_line smartface[i],smartface[i+1]
#}
#@target.add_line smartface.last,smartface[0]
case @operation
	when 0
		@target.add_face @smartface
	when 1
		vertices = @face.vertices
		firstedge = ""
		@smartface = []
		previousedge = []
		vertices.each {|v|
			if(v.edges.length>2)
				failed = 0
				boundedges = v.edges
				boundedges.delete_if {|x| x.line[1].perpendicular? @face.normal}
				if(boundedges.length > 0 && @smarttoggle==1)
					pt = Geom.intersect_line_plane(boundedges[0].line, @newplane)
				else
					pt = v.position.project_to_plane @newplane
				end
			else
				ovector = @face.normal
				ovector.length = @offset.length
				if((@offset.angle_between @face.normal) > Math::PI/2)
					ovector.reverse!
				end
				pt = Geom::Point3d.new(v.position) + ovector
			end
			if (firstedge=="")
				firstedge = [pt,v.position]
			else
				begin
					@target.add_face [previousedge,v.position,pt].flatten!
				rescue
					@target.add_line [previousedge,v.position,pt].flatten!
				end
			end
			previousedge = [pt,v.position]
			@smartface.push pt
		}
		begin
			@target.add_face [firstedge,previousedge[1],previousedge[0]].flatten!
		rescue
			@target.add_line [firstedge,previousedge[1],previousedge[0]].flatten!
		end
		begin
			@target.add_face @smartface
		rescue
			@target.add_line @smartface
		end
end

@drawtemp = 0
Sketchup.active_model.commit_operation
end

end # class SmartPP

if( not $smartpp_menu_loaded )
  UI.menu("Tools").add_item("Smart Push Pull") { Sketchup.active_model.select_tool SmartPP.new }
	$smartpp_menu_loaded = true
end