=begin
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
# Designed August 2009 by Fredo6

# Permission to use this software for any purpose and without fee is hereby granted
# Distribution of this software for commercial purpose is subject to:
#  - the expressed, written consent of the author
#  - the inclusion of the present copyright notice in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name			:   bootstrap_Curviloft.rb
# Original Date	:   5 Dec 2010
# Description	:   Bootstrap Loader for the Curviloft scripts
# Usage			:   This is the only Ruby file loaded at SU startup
#
# INVOKING CURVILOFT FROM OTHER SCRIPTS
# -------------------------------------
# Use a call to Curviloft.launch_action(action_code)
#   where <action_code> is passed as a Symbol:
#   - :loft_by_spline  --> Loft by Spline
#   - :loft_along_path --> Loft along Path
#   - :skinning        --> Skinning 
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
=end

module Curviloft

#---------------------------------------------------------------------------------------------------------------------------
# Overall Configuration for the Tools	
#---------------------------------------------------------------------------------------------------------------------------

MENU_PERSO = [:T_MenuTools_Fredo6Collection, "Tools", :T_MenuPlugins_Fredo6Collection, "Plugins"]

#---------------------------------------------------------------------------------------------------------------------------
#Constants for TOS  Modules (do not translate here, use Translation Dialog Box instead)	
#---------------------------------------------------------------------------------------------------------------------------

#Menu and Toolbar icons
T6[:CVL_LOFT_SPLINE_Menu] = "Loft by Spline"
T6[:CVL_LOFT_SPLINE_Tooltip] = "Create Loft junctions between surfaces based on Spline curves"
CVL_LOFT_SPLINE_Icon = "LoftSpline"

T6[:CVL_LOFT_PATH_Menu] = "Loft along path"
T6[:CVL_LOFT_PATH_Tooltip] = "Create Loft junctions following a given path"
CVL_LOFT_PATH_Icon = "LoftPath"

T6[:CVL_LOFT_SKIN_Menu] = "Skin Contours"
T6[:CVL_LOFT_SKIN_Tooltip] = "Skinning of shapes (Loft junctions following two pathes)"
CVL_LOFT_SKIN_Icon = "LoftSkin"

#--------------------------------------------------------
# Default Parameters
#--------------------------------------------------------

T6[:CVL_DEFAULT_SECTION_General] = "Parameters at startup of Sketchup"
T6[:CVL_COLOR_Wireframe] = "Color for wireframe"

#---------------------------------------------------------------------------------------------------------------------------------
# EXTERNAL API to launch Curviloft menus
# Action code must be passed as a symbol
#   - :loft_by_spline --> Loft by Spline
#   - :loft_along_path --> Loft along Path
#   - :skinning --> Skinning 
#---------------------------------------------------------------------------------------------------------------------------------
	
def Curviloft.launch_action(action_code)
	MYPLUGIN.launch_action action_code
end

#--------------------------------------------------------
# Startup routine (called from LibFredo6)
#--------------------------------------------------------
	
#Create all commands with menus and toolbar icons
def Curviloft.startup	

	#Top menu
	MYPLUGIN.declare_topmenu nil, MENU_PERSO

	#Declaring command icons
	MYPLUGIN.declare_separator
	MYPLUGIN.declare_command(:CVL_LOFT_SPLINE_) { Curviloft.launch_action :loft_by_spline }
	MYPLUGIN.declare_command(:CVL_LOFT_PATH_) { Curviloft.launch_action :loft_along_path }
	MYPLUGIN.declare_command(:CVL_LOFT_SKIN_) { Curviloft.launch_action :skinning }
	
	#Declaring the default parameter
	Curviloft.default_param
	
	#Startup of the Plugin
	MYPLUGIN.go	
	
end
	
#Declaring the Default Parameters	
def Curviloft.default_param
	dp = MYDEFPARAM
	dp.separator :CVL_DEFAULT_SECTION_General
	dp.declare :CVL_COLOR_Wireframe, "purple", "K"	
end
		
end	#End Module Curviloft
