=begin
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
# Designed by Fredo6 - Copyright April 2009

# Permission to use this software for any purpose and without fee is hereby granted
# Distribution of this software for commercial purpose is subject to:
#  - the expressed, written consent of the author
#  - the inclusion of the present copyright notice in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name			:   RoundCorner_Common.rb
# Original Date	:   30 April 2009 - version 2.0
# Description	:   Common environment for RoundCorner
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
=end

module RoundCorner

#---------------------------------------------------------------------------------------------------------------------------
# Overall Configuration for the Tools	
#---------------------------------------------------------------------------------------------------------------------------

MENU_PERSO = [:T_MenuTools_Fredo6Collection, "Tools", :T_MenuPlugins_Fredo6Collection, "Plugins"]

#---------------------------------------------------------------------------------------------------------------------------
#Constants for RoundCorner Module (do not translate here, use Translation Dialog Box instead)	
#---------------------------------------------------------------------------------------------------------------------------

#Menu and Toolbar icons
T6[:RDC_ROUND_Menu] = "Round Corner"
T6[:RDC_ROUND_Tooltip] = "Round corners in 3D"
RDC_ROUND_Icon = "Round"
T6[:RDC_SHARP_Menu] = "Sharp Corner"
T6[:RDC_SHARP_Tooltip] = "Sharp corners in 3D"
RDC_SHARP_Icon = "Sharp"
T6[:RDC_BEVEL_Menu] = "Bevel"
T6[:RDC_BEVEL_Tooltip] = "Bevel edges and corners"
RDC_BEVEL_Icon = "Bevel"


# Strings for the application
T6[:MSG_Main] = "Click on Edges, Vertex, Faces to add / remove edges (See Palette and contextual menu for options)"
T6[:MSG_Abort] = "Do you want to abort operation?"
T6[:MSG_AbortLeave] = "Do you want to finish operation before leaving the tool?"
T6[:MSG_ErrorFound] = "An Error was found when processing geometry\nCorner at fault is highlighted in the model"
T6[:MSG_SomeErrors] = "Some corners cannot be processed"
T6[:LABEL_Wait] = "WAIT"
T6[:LABEL_Finishing] = "Finishing"


#Contextual menus
T6[:MNU_Execute] = "Calculate Round Corners (Enter or click in empty space)"
T6[:MNU_Exit] = "Exit Tool (Click in empty space)"
T6[:MNU_UnselectAll] = "Clear all (ESC)"
T6[:MNU_EdgePropFilter] = "Filter on Edge selection"
T6[:MNU_EdgePropFilter2] = "Edge Prop. Filter"
T6[:MNU_EdgePropBorder] = "Borders"
T6[:TIP_EdgePropBorder] = "Edge Properties for created Borders"
T6[:MNU_EdgePropRound] = "Inner Edges"
T6[:TIP_EdgePropRound] = "Edge Properties for created round edges and corners"
T6[:MNU_Rounding] = "Super rounding at corner (round corners only)"
T6[:MNU_StrictOffset] = "Respect strict offset as far as possible"
T6[:MNU_Offset] = "Offset"
T6[:MNU_AllParam] = "Dialog box for all parameters"

#Text for Dilaog box
T6[:DLG_All_Title] = "Round Corner parameters"
T6[:DLG_All_Offset] = "Offset (reference orthogonal planes)"
T6[:DLG_All_Numseg] = "Number of segments for the rounding"
T6[:DLG_All_GoldenAxis] = "Main direction for pivot edges"
T6[:DLG_All_StrictOffset] = "Respect Strict Offset"
T6[:DLG_All_SuperRounding] = "Super Rounding of corners"

#Tooltip message
T6[:TIP_Computing] = "COMPUTING"
T6[:TIP_Interrupt] = "Click anywhere or Escape to interrupt the operation"
T6[:TIP_Aborted] = "ABORTED by user"
T6[:TIP_Time] = "Time: %1 second"
T6[:TIP_Count] = "Edges: %1 - Corners: %2"

T6[:TIP_InvalidBest] = "Invalid (Group or Component)"
T6[:TIP_Invalid] = "Invalid"
T6[:TIP_WrongNbFaces] = "Not 2 faces"
T6[:TIP_WrongCoplanar] = "Coplanar edge"
T6[:TIP_WrongFilter] = "Property filter"

T6[:TIP_Execute] = "Click to Execute"
T6[:TIP_Exit] = "Click to Exit"
T6[:TIP_Select_Edge] = "Select Edge"
T6[:TIP_UnSelect_Edge] = "Unselect Edge"
T6[:TIP_Select_Vertex] = "Select All edges at Vertex"
T6[:TIP_UnSelect_Vertex] = "Unselect All edges at Vertex"
T6[:TIP_Select_Face] = "Select All edges of Face"
T6[:TIP_UnSelect_Face] = "Unselect All edges of Face"
T6[:TIP_Offset] = "Offset value by reference to orthogonal faces (VCB: length in current units)"
T6[:TIP_Numseg] = "Number of segments for the rounding (VCB: number + s)"
T6[:TIP_Axis] = "Main direction for pivot edges (use Arrows to change)"
T6[:TIP_SaveLetter] = "Save Current Parameters as %1"
T6[:TIP_LetterInfo] = "Offset = %1 - Nb Seg = %2"
T6[:TIP_LetterVoid] = "Restore Parameters for %1"


#Colors and marks used by the RoundCorner Tool
T6[:DEFAULT_Color_Edges] = "Color for Regular edges"
T6[:DEFAULT_Color_Pivots] = "Color for Pivot edges"
T6[:DEFAULT_Color_PivotsConvex] = "Color for Pivot edges at convex corners"
T6[:DEFAULT_Color_PivotsRound] = "Color for Pivot edges when Round"
T6[:DEFAULT_Color_Borders] = "Color for Borders"
T6[:DEFAULT_Color_Implicit] = "Color for Implicit edges"
T6[:DEFAULT_Color_Excluded] = "Color for Excluded edges"

#Labels for Default Parameters
T6[:DEFAULT_SectionAll] = "Active Options at start up"
T6[:DEFAULT_SectionColors] = "Colors for Edges and Borders"
T6[:DEFAULT_NumberLetter] = "Number of Parameter Savings designator (A, B, C, ...)"
T6[:DEFAULT_Flag_EdgePropFilter] = "Filter on Edge selection"
T6[:DEFAULT_Flag_EdgePropBorder] = "Properties of Border edges"
T6[:DEFAULT_Flag_EdgePropRound] = "Properties of Inner edges for roundings and corners"
T6[:DEFAULT_Flag_StrictOffset] = "Respect Strict Offset"
T6[:DEFAULT_Flag_Rounding] = "Super Rounding (Convex and round edges only)"
T6[:DEFAULT_Flag_Axis] = "Main Direction for pivot edges (orientation of round corners)"
T6[:DEFAULT_Flag_Numseg] = "Number of segments for roundings"

T6[:DEFAULT_Key_StrictOffset] = "Toggle Strict Offset"
T6[:DEFAULT_Key_Rounding] = "Toggle Super rounding at corner"

#---------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------
# EXTERNAL API to launch RoundCorner menus
# Action code must be passed as a symbol
#   - :round --> Round corners
#   - :sharp --> Sharp corners
#   - :bevel  --> Bevel
#---------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------
	
def RoundCorner.launch_action(action_code)
	MYPLUGIN.launch_action action_code
end

#Max number of segments for a rounding
def RoundCorner.max_seg ; 60 ; end

#--------------------------------------------------------------------------------------------------------------
# Plugin Startup Method
#--------------------------------------------------------------------------------------------------------------			 

def RoundCorner.startup

	#Top menu
	MYPLUGIN.declare_topmenu nil, MENU_PERSO
	
	#Declaring Commands
	MYPLUGIN.declare_command(:RDC_ROUND_) { RoundCorner.launch_action :round }
	MYPLUGIN.declare_command(:RDC_SHARP_) { RoundCorner.launch_action :sharp }
	MYPLUGIN.declare_command(:RDC_BEVEL_) { RoundCorner.launch_action :bevel }
	MYPLUGIN.default_icons_visible [:RDC_ROUND_, :RDC_SHARP_, :RDC_BEVEL_]

	#Common Default Parameters
	MYDEFPARAM.separator :DEFAULT_SectionAll
	MYDEFPARAM.declare :DEFAULT_NumberLetter, 2, 'I:>=0<=4'
	MYDEFPARAM.declare :DEFAULT_Flag_Numseg, 6, "I:>0<#{RoundCorner.max_seg}"
	MYDEFPARAM.declare_edge_prop_PSMH :DEFAULT_Flag_EdgePropFilter, 'P' 
	MYDEFPARAM.declare :DEFAULT_Flag_StrictOffset, false, 'B'
	MYDEFPARAM.declare :DEFAULT_Flag_Rounding, true, 'B'
	MYDEFPARAM.declare :DEFAULT_Flag_Axis, 'Z', 'H', ['X', 'Y', 'Z']
	MYDEFPARAM.declare_edge_prop_SMH :DEFAULT_Flag_EdgePropBorder, 'S' 
	MYDEFPARAM.declare_edge_prop_SMH :DEFAULT_Flag_EdgePropRound, 'S;;M' 
	Traductor::SelMode.default_param MYDEFPARAM, :RDC_
	
	#Colors for edges and borders
	MYDEFPARAM.separator :DEFAULT_SectionColors
	MYDEFPARAM.declare :DEFAULT_Color_Edges, "red", 'K'
	MYDEFPARAM.declare :DEFAULT_Color_Pivots, "darkred", 'K'
	MYDEFPARAM.declare :DEFAULT_Color_PivotsConvex, "purple", 'K'
	MYDEFPARAM.declare :DEFAULT_Color_PivotsRound, "darkorange", 'K'
	MYDEFPARAM.declare :DEFAULT_Color_Borders, "green", 'K'
	MYDEFPARAM.declare :DEFAULT_Color_Implicit, "orange", 'K'
	MYDEFPARAM.declare :DEFAULT_Color_Excluded, "yellow", 'K'
	
	#function keys
	fkeys = Traductor::FKeyOption.fkeys
	MYDEFPARAM.separator :T_DEFAULT_SectionFunctionKey
	MYDEFPARAM.declare :DEFAULT_Key_StrictOffset, 'F4', 'H', fkeys
	MYDEFPARAM.declare :DEFAULT_Key_Rounding, 'F5', 'H', fkeys
				
	#Startup of the Plugin
	MYPLUGIN.go
end
	
end	#End Module RoundCorner
